using System;
using System.Linq;

public class TrkaTakmicara
{
    public static void Main(string[] args)
    {
        string unosN = Console.ReadLine();
        if (string.IsNullOrEmpty(unosN) || !int.TryParse(unosN, out int N))
        {
            return;
        }

        if (N < 2)
        {
            Console.WriteLine(0);
            return;
        }

        long[] U = new long[N];
        long[] V = new long[N];

        for (int i = 0; i < N; i++)
        {
            string linija = Console.ReadLine();
            if (string.IsNullOrEmpty(linija)) continue;
            
            string[] delovi = linija.Split(' ');
            
            if (delovi.Length != 2 || 
                !long.TryParse(delovi[0], out long xi) || 
                !long.TryParse(delovi[1], out long yi))
            {
                continue;
            }

            U[i] = xi + yi;
            V[i] = xi - yi;
        }

        long ukupanBrojPozdrava = 0;

        // --- Susreti tipa U (x+y = konstanta) ---
        Array.Sort(U);
        
        long brojac = 0;
        long vrednost = U[0];
        brojac = 1;

        for (int i = 1; i < N; i++)
        {
            if (U[i] == vrednost)
            {
                brojac++;
            }
            else
            {
                if (brojac >= 2)
                {
                    ukupanBrojPozdrava += brojac * (brojac - 1);
                }
                vrednost = U[i];
                brojac = 1;
            }
        }

        if (brojac >= 2)
        {
            ukupanBrojPozdrava += brojac * (brojac - 1);
        }

        // --- Susreti tipa V (x-y = konstanta) ---
        Array.Sort(V);

        brojac = 0;
        vrednost = V[0];
        brojac = 1;

        for (int i = 1; i < N; i++)
        {
            if (V[i] == vrednost)
            {
                brojac++;
            }
            else
            {
                if (brojac >= 2)
                {
                    ukupanBrojPozdrava += brojac * (brojac - 1);
                }
                vrednost = V[i];
                brojac = 1;
            }
        }

        if (brojac >= 2)
        {
            ukupanBrojPozdrava += brojac * (brojac - 1);
        }
        
        Console.WriteLine(ukupanBrojPozdrava);
    }
}